<?php
/* --------------------------------------------------------------
   TrackingCodeApiRequestValidator.php 2020-03-10
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Api\TrackingCode;

/**
 * Class TrackingCodeApiRequestValidator
 *
 * @package Gambio\Api\TrackingCode
 */
class TrackingCodeApiRequestValidator
{
    /**
     * @param array $parsedBody
     *
     * @return string[][]
     */
    public function validatePostRequestBody(array $parsedBody): array
    {
        $mandatory = [
            'orderId',
            'code',
            'languageId',
            'parcelService.id',
            'parcelService.name',
            'parcelService.url',
            'parcelService.comment',
            'createdOn',
        ];
        
        return $this->checkAttributes($parsedBody, $mandatory);
    }
    
    
    /**
     * @param array $parsedBody
     *
     * @return string[][]
     */
    public function validatePutRequestBody(array $parsedBody): array
    {
        $mandatory = [
            'id',
            'orderId',
            'code',
            'languageId',
            'parcelService.id',
            'parcelService.name',
            'parcelService.url',
            'parcelService.comment',
            'createdOn',
        ];
        
        return $this->checkAttributes($parsedBody, $mandatory);
    }
    
    
    /**
     * @param array $parsedBody
     * @param array $mandatory
     *
     * @return array
     */
    private function checkAttributes(array $parsedBody, array $mandatory): array
    {
        $errors = [];
        
        foreach ($parsedBody as $reference => $trackingCodeDetails) {
            $providedAttributes = $this->getArrayKeysRecursive($trackingCodeDetails);
            $missingAttributes  = array_diff($mandatory, $providedAttributes);
            
            if (count($missingAttributes) > 0) {
                $errors[$reference] = [];
                foreach ($missingAttributes as $missingAttribute) {
                    $errors[$reference][] = 'Attribute "' . $missingAttribute . '" is missing.';
                }
            }
        }
        
        return $errors;
    }
    
    
    /**
     * @param array  $array
     * @param string $connectionString
     *
     * @return array
     */
    private function getArrayKeysRecursive(array $array, string $connectionString = '.'): array
    {
        $keys = [];
        foreach ($array as $key => $value) {
            if (!is_array($value)) {
                $keys[] = $key;
                continue;
            }
            
            foreach ($this->getArrayKeysRecursive($value) as $subKey) {
                $keys[] = $key . $connectionString . $subKey;
            }
        }
        
        return $keys;
    }
}